# Prepare dataset
Suppose you have downloaded the original dataset, we need to preprocess the data and save it as pickle file. Remember to set your path to the root of processed dataset in [configs/*.yaml](configs/).

## Preprocess
**CASIA-B** 

Download URL: http://www.cbsr.ia.ac.cn/GaitDatasetB-silh.zip
- Original
    ```
    CASIA-B
        001 (subject)
            bg-01 (type)
                000 (view)
                    001-bg-01-000-001.png (frame)
                    001-bg-01-000-002.png (frame)
                    ......
                ......
            ......
        ......
    ```
- Run `python datasets/pretreatment.py --input_path CASIA-B --output_path CASIA-B-pkl`
- Processed
    ```
    CASIA-B-pkl
        001 (subject)
            bg-01 (type)
                    000 (view)
                        000.pkl (contains all frames)
                ......
            ......
        ......
    ```
**OUMVLP** 

Step1: Download URL: http://www.am.sanken.osaka-u.ac.jp/BiometricDB/GaitMVLP.html

Step2: Unzip the dataset, you will get a structure directory like:
```
python datasets/OUMVLP/extractor.py --input_path Path_of_OUMVLP-base --output_path Path_of_OUMVLP-raw --password Given_Password
```  

- Original
    ```
    OUMVLP-raw
        Silhouette_000-00 (view-sequence)
            00001 (subject)
                0001.png (frame)
                0002.png (frame)
                ......
            00002
                0001.png (frame)
                0002.png (frame)
                ......
            ......
        Silhouette_000-01
            00001
                0001.png (frame)
                0002.png (frame)
                ......
            00002
                0001.png (frame)
                0002.png (frame)
                ......
            ......
        Silhouette_015-00
            ......
        Silhouette_015-01
            ......
        ......
    ```
Step3 : To rearrange directory of OUMVLP dataset, turning to id-type-view structure, Run 
```
python datasets/OUMVLP/rearrange_OUMVLP.py --input_path Path_of_OUMVLP-raw --output_path Path_of_OUMVLP-rearranged
```  

Step4: Transforming images to pickle file, run 
```
python datasets/pretreatment.py --input_path Path_of_OUMVLP-rearranged --output_path Path_of_OUMVLP-pkl
```

- Processed
    ```
    OUMVLP-pkl
        00001 (subject)
            00 (sequence)
                000 (view)
                    000.pkl (contains all frames)
                015 (view)
                    015.pkl (contains all frames)
                ...
            01 (sequence)
                000 (view)
                    000.pkl (contains all frames)
                015 (view)
                    015.pkl (contains all frames)
                ......
        00002 (subject)
            ......
        ......
    ```


**GREW** 

Step1: Download the data

Step2: [Unzip](https://github.com/GREW-Benchmark/GREW-Benchmark) the dataset, you will get a structure directory like:

- Original
    ```
    GREW-raw
    ├── train
        ├── 00001
            ├── 4XPn5Z28
                ├── 00001.png
                ├── 00001_2d_pose.txt
                ├── 00001_3d_pose.txt
            ├── 4XPn5Z28_gei.png
    ├── test
        ├── gallery
            ├── 00001
                ├── 79XJefi8
                    ├── 00001.png
                    ├── 00001_2d_pose.txt
                    ├── 00001_3d_pose.txt
                ├── 79XJefi8_gei.png
        ├── probe
            ├── 01DdvEHX
                ├── 00001.png
                ├── 00001_2d_pose.txt
                ├── 00001_3d_pose.txt
            ├── 01DdvEHX_gei.png
        ...
    ...
            
Step3 : To rearrange directory of GREW dataset, turning to id-type-view structure, Run 
```
python datasets/GREW/rearrange_GREW.py --input_path Path_of_GREW-raw --output_path Path_of_GREW-rearranged
```  

Step4: Transforming images to pickle file, run 
```
python datasets/pretreatment.py --input_path Path_of_GREW-rearranged --output_path Path_of_GREW-pkl
```

- Processed
    ```
    GREW-pkl
    ├── 00001train (subject in training set)
        ├── 00
            ├── 4XPn5Z28
                ├── 4XPn5Z28.pkl
            ├──5TXe8svE
                ├── 5TXe8svE.pkl
                ......
    ├── 00001 (subject in testing set)
        ├── 01
            ├── 79XJefi8
                ├── 79XJefi8.pkl
        ├── 02
            ├── t16VLaQf
                ├── t16VLaQf.pkl
    ├── probe
        ├── etaGVnWf
            ├── etaGVnWf.pkl
        ├── eT1EXpgZ
            ├── eT1EXpgZ.pkl
        ...
    ...
    ```

## Split dataset
You can use the partition file in dataset folder directly, or you can create yours. Remember to set your path to the partition file in [configs/*.yaml](configs/).
